/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ReceiverCallNotAllowedException;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.parse.Parse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

class ConnectivityNotifier
extends BroadcastReceiver {
    static final String TAG = "com.parse.ConnectivityNotifier";
    private static final ConnectivityNotifier singleton = new ConnectivityNotifier();
    private Set<ConnectivityListener> listeners = new HashSet<ConnectivityListener>();
    private boolean hasRegisteredReceiver = false;
    private final Object lock = new Object();

    ConnectivityNotifier() {
    }

    static ConnectivityNotifier getNotifier() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConnectivityListener delegate, Context context) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(delegate);
            this.tryToRegisterForNetworkStatusNotifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConnectivityListener delegate) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(delegate);
            this.tryToRegisterForNetworkStatusNotifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryToRegisterForNetworkStatusNotifications() {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasRegisteredReceiver) {
                return true;
            }
            try {
                if (Parse.applicationContext == null) {
                    return false;
                }
                Parse.applicationContext.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                this.hasRegisteredReceiver = true;
                return true;
            }
            catch (ReceiverCallNotAllowedException e) {
                Parse.logV(TAG, "Cannot register a broadcast receiver because the executing thread is currently in a broadcast receiver. Will try again later.");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        ArrayList<ConnectivityListener> listenersCopy;
        Object object = this.lock;
        synchronized (object) {
            listenersCopy = new ArrayList<ConnectivityListener>(this.listeners);
        }
        for (ConnectivityListener delegate : listenersCopy) {
            delegate.networkConnectivityStatusChanged(intent);
        }
    }

    public boolean isConnected() {
        if (Parse.applicationContext == null) {
            Parse.logW(TAG, "Trying to check network connectivity without a known context. Has Parse.initialize been called from Application.onCreate? (Not Activity.onCreate)");
            return true;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)Parse.applicationContext.getSystemService("connectivity");
        if (connectivityManager != null) {
            NetworkInfo network = connectivityManager.getActiveNetworkInfo();
            return network == null || network.isConnected();
        }
        return true;
    }

    protected static interface ConnectivityListener {
        public void networkConnectivityStatusChanged(Intent var1);
    }
}

