/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Looper;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class Synchronizer {
    boolean done = false;
    CountDownLatch latch = new CountDownLatch(1);

    Synchronizer() {
    }

    void start(int count) {
        this.latch = new CountDownLatch(count);
    }

    void finish() {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new RuntimeException("finish() should be called from the UI thread");
        }
        if (this.done) {
            throw new RuntimeException("finish() was called too much");
        }
        this.latch.countDown();
    }

    void assertFinishes() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            throw new RuntimeException("assertFinishes() should *not* be called from the UI thread");
        }
        try {
            Thread.sleep(500L);
            this.done = this.latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (!this.done) {
            throw new RuntimeException("finish() was never called");
        }
    }
}

